package ru.yandex.blackbox;

import java.util.Map;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;

public enum BlackboxDbfield {
    MDB("hosts.db_id.2"),
    SUID("subscription.suid.2"),
    REG_DATE("userinfo.reg_date.uid"),
    LOGIN_RULE("subscription.login_rule.2"),
    SID_CLOUD("subscription.suid.59"),
    SID_YASTAFF("subscription.suid.669"),
    FIRSTNAME("userinfo.firstname.uid"),
    LASTNAME("userinfo.lastname.uid"),
    COUNTRY("userinfo.country.uid"),
    ;

    private final String dbfield;

    BlackboxDbfield(final String dbfield) {
        this.dbfield = dbfield;
    }

    public String dbfieldName() {
        return dbfield;
    }

    public void addToMap(
        final Map<BlackboxDbfield, String> map,
        final JsonObject value)
        throws JsonBadCastException
    {
        if (value != JsonNull.INSTANCE) {
            String stringValue = value.asString();
            if (!stringValue.isEmpty()) {
                map.put(this, stringValue);
            }
        }
    }
}

