package ru.yandex.blackbox;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public class BlackboxErrorException extends BlackboxException {
    public static final long ERROR_OK = 0L;
    public static final long ERROR_UNKNOWN = 1L;
    public static final long ERROR_INVALID_PARAMS = 2L;
    public static final long ERROR_DB_FETCHFAILED = 9L;
    public static final long ERROR_DB_EXCEPTION = 10L;
    public static final long ERROR_ACCESS_DENIED = 21L;

    private static final long serialVersionUID = 0;

    private final String message;
    private final long errorId;
    private final String errorValue;

    public BlackboxErrorException(final JsonMap map)
        throws JsonException
    {
        message = map.getString("error");
        JsonMap exception = map.getMap("exception");
        errorId = exception.getLong("id");
        errorValue = exception.getString("value");
    }

    public long errorId() {
        return errorId;
    }

    public String errorValue() {
        return errorValue;
    }

    public String message() {
        return message;
    }

    public boolean shouldRetry() {
        return errorId == ERROR_DB_FETCHFAILED
            || errorId == ERROR_DB_EXCEPTION;
    }

    @Override
    public String getMessage() {
        return errorValue + '(' + errorId + "): " + message;
    }
}

