package ru.yandex.blackbox;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;

public class BlackboxFamilyInfoAsyncResponseConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<BlackboxFamilyInfo>
{
    public BlackboxFamilyInfoAsyncResponseConsumer(final HttpEntity entity)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    protected BlackboxFamilyInfo buildResult(
        final HttpContext context,
        final JsonObject value)
        throws Exception
    {
        return new BlackboxFamilyInfo(value);
    }
}

