package ru.yandex.blackbox;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public enum BlackboxFamilyInfoAsyncResponseConsumerFactory
    implements HttpAsyncResponseConsumerFactory<BlackboxFamilyInfo>
{
    INSTANCE;

    public static final HttpAsyncResponseConsumerFactory<BlackboxFamilyInfo>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    @Override
    public BlackboxFamilyInfoAsyncResponseConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new BlackboxFamilyInfoAsyncResponseConsumer(
            response.getEntity());
    }
}

