package ru.yandex.blackbox;

import java.io.IOException;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.parser.string.PositiveLongValidator;

public class BlackboxFamilyMember
    extends AbstractStringBuilderable
    implements JsonValue
{
    private final long uid;

    public BlackboxFamilyMember(final JsonMap map) throws JsonException {
        uid = map.get("uid", PositiveLongValidator.INSTANCE);
    }

    public long uid() {
        return uid;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append("(uid=");
        sb.append(uid);
        sb.append(')');
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("uid");
        writer.value(uid);
        writer.endObject();
    }

    public JsonMap toJsonObject(final ContainerFactory containerFactory) {
        JsonMap result = new JsonMap(containerFactory, 2);
        result.put("uid", new JsonLong(uid));
        return result;
    }
}

