package ru.yandex.blackbox;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectorsFactory;

public class BlackboxOAuthAsyncResponseConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<BlackboxUserinfo>
{
    private final BlackboxOAuthRequest request;

    public BlackboxOAuthAsyncResponseConsumer(
        final HttpEntity entity,
        final BlackboxOAuthRequest request)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
        this.request = request;
    }

    @Override
    protected BlackboxUserinfo buildResult(
        final HttpContext context,
        final JsonObject value)
        throws Exception
    {
        try {
            JsonMap root = value.asMap();
            JsonMap status = root.getMapOrNull("status");
            if (status == null) {
                throw new BlackboxErrorException(root);
            }
            long statusId = status.getLong("id");
            if (statusId == 0L) {
                return new BlackboxUserinfo(request, root);
            } else {
                throw new BlackboxOAuthException(
                    status.getString("value"),
                    statusId,
                    root.getString("error"));
            }
        } catch (JsonException e) {
            throw new BlackboxMalformedResponseException(
                "Failed to parse blackbox response: " + value,
                e);
        }
    }
}

