package ru.yandex.blackbox;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public class BlackboxOAuthAsyncResponseConsumerFactory
    implements HttpAsyncResponseConsumerFactory<BlackboxUserinfo>
{
    private final BlackboxOAuthRequest request;

    public BlackboxOAuthAsyncResponseConsumerFactory(
        final BlackboxOAuthRequest request)
    {
        this.request = request;
    }

    @Override
    public BlackboxOAuthAsyncResponseConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new BlackboxOAuthAsyncResponseConsumer(
            response.getEntity(),
            request);
    }
}

