package ru.yandex.blackbox;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;

public class BlackboxOAuthRequest
    extends BlackboxRequestBase<BlackboxOAuthRequest>
{
    private final String oauthToken;
    private final String scopes;

    public BlackboxOAuthRequest(
        final String oauthToken,
        final String scopes)
    {
        super("oauth");
        this.oauthToken = oauthToken;
        this.scopes = scopes;
    }

    @Override
    public BlackboxOAuthRequest self() {
        return this;
    }

    @Override
    public QueryConstructor query() throws BadRequestException {
        QueryConstructor query = super.query();
        query.append("oauth_token", oauthToken);
        StringBuilder sb = query.sb();
        sb.append("&scopes=");
        sb.append(scopes);
        return query;
    }
}

