package ru.yandex.blackbox;

import java.util.Map;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;

public enum BlackboxPhoneAttributeType {
    PHONE_NUMBER(101),
    PHONE_E164_NUMBER(102),
    PHONE_MASKED_E164_NUMBER(104),
    IS_BOUND(106),
    IS_SECURED(108),
    ;

    private final int id;

    BlackboxPhoneAttributeType(final int id) {
        this.id = id;
    }

    public int id() {
        return id;
    }

    public void addToMap(
        final Map<BlackboxPhoneAttributeType, String> map,
        final JsonObject value)
        throws JsonBadCastException
    {
        if (value != JsonNull.INSTANCE) {
            String stringValue = value.asString();
            if (!stringValue.isEmpty()) {
                map.put(this, stringValue);
            }
        }
    }
}

