package ru.yandex.blackbox;

public class BlackboxSessionException extends BlackboxException {
    private static final long serialVersionUID = 0;

    private static final int EXPIRED = 2;
    private static final int INVALID = 5;

    private final long statusId;
    private final String status;
    private final String errorMessage;

    public BlackboxSessionException(
        final String status,
        final long statusId,
        final String error)
    {
        super(status + '(' + statusId + "): " + error);
        this.statusId = statusId;
        this.status = status;
        this.errorMessage = error;
    }

    public long errorId() {
        return statusId;
    }

    public String status() {
        return status;
    }

    public String errorMessage() {
        return errorMessage;
    }

    public boolean expired() {
        return statusId == EXPIRED;
    }

    public boolean invalid() {
        return statusId == INVALID;
    }
}
