package ru.yandex.blackbox;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public class BlackboxSessionUserinfo extends BlackboxUserinfo {
    private final String userTicket;
    private final long expiresIn;

    public BlackboxSessionUserinfo(
        final BlackboxSessionidRequest request,
        final JsonMap map)
        throws BlackboxException
    {
        super(request, map);

        try {
            expiresIn = map.getLong("expires_in", 0L);
            if (request.requestTvmTicket()) {
                userTicket = map.getString("user_ticket", null);
                if (userTicket == null || userTicket.isEmpty()) {
                    throw new BlackboxException(
                        "User ticket was requested, but not received " + map);
                }
            } else {
                userTicket = null;
            }
        } catch (JsonException e) {
            throw new BlackboxMalformedResponseException(
                "Failed to parse user_ticket or expires_is from: " + map,
                e);
        }
    }

    public String userTicket() {
        return userTicket;
    }

    public long expiresIn() {
        return expiresIn;
    }
}
