package ru.yandex.blackbox;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectorsFactory;

public class BlackboxSessionidAsyncResponseConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<BlackboxSessionUserinfo>
{
    private final BlackboxSessionidRequest request;

    public BlackboxSessionidAsyncResponseConsumer(
        final HttpEntity entity,
        final BlackboxSessionidRequest request)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
        this.request = request;
    }

    @Override
    protected BlackboxSessionUserinfo buildResult(
        final HttpContext context,
        final JsonObject value)
        throws Exception
    {
        try {
            JsonMap root = value.asMap();
            JsonMap status = root.getMapOrNull("status");
            if (status == null) {
                throw new BlackboxErrorException(root);
            }
            long statusId = status.getLong("id");
            if (statusId == 0L) {
                return new BlackboxSessionUserinfo(request, root);
            } else {
                throw new BlackboxSessionException(
                    status.getString("value"),
                    statusId,
                    root.getString("error"));
            }
        } catch (JsonException e) {
            throw new BlackboxMalformedResponseException(
                "Failed to parse blackbox response: " + value,
                e);
        }
    }
}
