package ru.yandex.blackbox;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public class BlackboxSessionidAsyncResponseConsumerFactory
    implements HttpAsyncResponseConsumerFactory<BlackboxSessionUserinfo>
{
    private final BlackboxSessionidRequest request;

    public BlackboxSessionidAsyncResponseConsumerFactory(
        final BlackboxSessionidRequest request)
    {
        this.request = request;
    }

    @Override
    public BlackboxSessionidAsyncResponseConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new BlackboxSessionidAsyncResponseConsumer(
            response.getEntity(),
            request);
    }
}
