package ru.yandex.blackbox;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;

public class BlackboxSessionidRequest
    extends BlackboxRequestBase<BlackboxSessionidRequest>
{
    private static final String SESSION_ID = "sessionid";

    private final String sessionId;
    private final String host;
    private final boolean userTvmTicket;

    public BlackboxSessionidRequest(
        final String sessionId,
        final String host,
        final boolean requestTvmTicket)
    {
        super(SESSION_ID);

        this.sessionId = sessionId;
        this.host = host;
        this.userTvmTicket = requestTvmTicket;
    }

    public BlackboxSessionidRequest(final String sessionId, final String host) {
        this(sessionId, host, false);
    }

    @Override
    public BlackboxSessionidRequest self() {
        return this;
    }

    @Override
    public QueryConstructor query() throws BadRequestException {
        QueryConstructor query = super.query();

        query.append(SESSION_ID, sessionId);
        query.append("host", host);

        if (userTvmTicket) {
            query.append("get_user_ticket", "true");
        }

        return query;
    }

    public boolean requestTvmTicket() {
        return userTvmTicket;
    }
}
