package ru.yandex.blackbox;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;

public class BlackboxUserinfoAsyncResponseConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<BlackboxUserinfos>
{
    private final BlackboxUserinfoRequest request;

    public BlackboxUserinfoAsyncResponseConsumer(
        final HttpEntity entity,
        final BlackboxUserinfoRequest request)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
        this.request = request;
    }

    @Override
    protected BlackboxUserinfos buildResult(
        final HttpContext context,
        final JsonObject value)
        throws Exception
    {
        JsonMap root = value.asMap();
        JsonList users = root.getListOrNull("users");
        if (users == null) {
            throw new BlackboxErrorException(root);
        }
        if (users.isEmpty()) {
            throw new BlackboxMalformedResponseException(
                "No users found in " + root);
        }
        BlackboxUserinfos userinfos = new BlackboxUserinfos(users.size());
        if (request.allowNotFound()) {
            // Will be used for multi uids requests, so results can be easyly
            // mapped to requests
            for (JsonObject user: users) {
                try {
                    userinfos.add(new BlackboxUserinfo(request, user.asMap()));
                } catch (BlackboxNotFoundException e) {
                    // keep calm and carry on
                }
            }
        } else {
            for (JsonObject user: users) {
                userinfos.add(new BlackboxUserinfo(request, user.asMap()));
            }
            if (request.expectedResultsCount() != userinfos.size()) {
                throw new BlackboxMalformedResponseException(
                    "Expected userinfos count is "
                    + request.expectedResultsCount()
                    + " but " + userinfos.size() + " found: " + root);
            }
        }
        return userinfos;
    }
}

