package ru.yandex.blackbox;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveLongValidator;

public class BlackboxUserinfoFamilyInfo {
    private final String id;
    private final long adminUid;

    public BlackboxUserinfoFamilyInfo(final JsonMap map) throws JsonException {
        id = map.get("family_id", NonEmptyValidator.INSTANCE);
        adminUid = map.get("admin_uid", PositiveLongValidator.INSTANCE);
    }

    public String id() {
        return id;
    }

    public long adminUid() {
        return adminUid;
    }
}

