package ru.yandex.blackbox;

import java.util.Locale;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;

public class BlackboxUserinfoRequest
    extends BlackboxRequestBase<BlackboxUserinfoRequest>
{
    private static final String METHOD = "userinfo";

    private final BlackboxUserIdType userIdType;
    private final Object userIdValue;
    private final Object[] userIdValues;
    private final int expectedResultsCount;
    private String sid = "2";
    private boolean allowNotFound = false;

    public BlackboxUserinfoRequest(
        final BlackboxUserIdType userIdType,
        final Object userIdValue)
    {
        super(METHOD);
        this.userIdType = userIdType;
        this.userIdValue = userIdValue;
        userIdValues = null;
        expectedResultsCount = 1;
    }

    public BlackboxUserinfoRequest(final Object userIdValue) {
        super(METHOD);
        this.userIdValue = userIdValue;
        userIdType = BlackboxUserIdType.UID;
        userIdValues = null;
        expectedResultsCount = 1;
    }

    public BlackboxUserinfoRequest(
        final long userIdValue,
        final long... userIdValues)
    {
        super(METHOD);
        this.userIdValue = userIdValue;
        this.userIdValues = new Object[userIdValues.length];
        for (int i = 0; i < userIdValues.length; ++i) {
            this.userIdValues[i] = userIdValues[i];
        }
        userIdType = BlackboxUserIdType.UID;
        expectedResultsCount = userIdValues.length + 1;
    }

    public int expectedResultsCount() {
        return expectedResultsCount;
    }

    public BlackboxUserinfoRequest sid(final String sid) {
        this.sid = sid;
        return this;
    }

    public boolean allowNotFound() {
        return allowNotFound;
    }

    public BlackboxUserinfoRequest allowNotFound(final boolean allowNotFound) {
        this.allowNotFound = allowNotFound;
        return this;
    }

    @Override
    public BlackboxUserinfoRequest self() {
        return this;
    }

    @Override
    public QueryConstructor query() throws BadRequestException {
        QueryConstructor query = super.query();
        StringBuilder sb = query.sb();
        sb.append("&sid=");
        sb.append(sid);
        String userIds = userIdValue.toString();
        if (userIdValues != null) {
            StringBuilder ids = new StringBuilder(userIds);
            for (Object value: userIdValues) {
                ids.append(',');
                ids.append(value.toString());
            }
            userIds = new String(ids);
        }
        query.append(userIdType.name().toLowerCase(Locale.ROOT), userIds);
        return query;
    }
}

