package ru.yandex.blackbox;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonNull;

public class BlackboxUserinfos extends ArrayList<BlackboxUserinfo> {
    private static final long serialVersionUID = 0L;

    public BlackboxUserinfos(final int capacity) {
        super(capacity);
    }

    public BlackboxUserinfos(final List<BlackboxUserinfo> list) {
        super(list);
    }

    public JsonList toJsonObject(final ContainerFactory containerFactory) {
        int size = size();
        JsonList result = new JsonList(containerFactory, size);
        for (int i = 0; i < size; ++i) {
            BlackboxUserinfo userinfo = get(i);
            if (userinfo == null) {
                result.add(JsonNull.INSTANCE);
            } else {
                result.add(userinfo.toJsonObject(containerFactory));
            }
        }
        return result;
    }
}

