package ru.yandex.blackbox;

import java.util.List;

import org.apache.http.concurrent.FutureCallback;

public class SingleUserinfoBlackboxCallback
    extends AbstractBlackboxCallback<List<BlackboxUserinfo>, BlackboxUserinfo>
{
    public SingleUserinfoBlackboxCallback(
        final FutureCallback<? super BlackboxUserinfo> callback)
    {
        super(callback);
    }

    @Override
    public void completed(final List<BlackboxUserinfo> userinfos) {
        if (userinfos.size() == 1) {
            callback.completed(userinfos.get(0));
        } else {
            failed(
                new BlackboxMalformedResponseException(
                    "Wrong userinfos count: " + userinfos));
        }
    }
}

