package ru.yandex.cokemulator.srw;

import org.apache.http.entity.ContentType;

import ru.yandex.client.cocaine.worker.http.unistorage.AbstractUnistorageHttpServiceConfigBuilder;
import ru.yandex.cokemulator.DataType;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.util.storage.DataExtractorConfig;
import ru.yandex.util.storage.DataExtractorConfigBuilder;

public abstract class AbstractCokemulatorSrwConfigBuilder
    <T extends AbstractCokemulatorSrwConfigBuilder<T>>
    extends AbstractUnistorageHttpServiceConfigBuilder<T>
    implements CokemulatorSrwConfig
{
    private int concurrency;
    private JniWrapperConfigBuilder jniWrapperConfig;
    private DataType dataType;
    private DataExtractorConfigBuilder dataExtractorConfig;
    private ContentType contentType;

    protected AbstractCokemulatorSrwConfigBuilder(
        final CokemulatorSrwConfig config)
    {
        super(config);
        concurrency(config.concurrency());
        jniWrapperConfig(config.jniWrapperConfig());
        dataType(config.dataType());
        dataExtractorConfig(config.dataExtractorConfig());
        contentType(config.contentType());
    }

    protected AbstractCokemulatorSrwConfigBuilder(
        final IniConfig config,
        final CokemulatorSrwConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig cokemulator = config.section("cokemulator");
        concurrency = CONCURRENCY.extract(cokemulator, defaults.concurrency());
        jniWrapperConfig = new JniWrapperConfigBuilder(
            cokemulator,
            defaults.jniWrapperConfig());
        dataType = cokemulator.getEnum(
            DataType.class,
            "data-type",
            defaults.dataType());
        dataExtractorConfig = new DataExtractorConfigBuilder(
            cokemulator,
            defaults.dataExtractorConfig());
        contentType = cokemulator.get(
            "content-type",
            defaults.contentType(),
            x -> ContentType.create(x));
    }

    @Override
    public int concurrency() {
        return concurrency;
    }

    public T concurrency(final int concurrency) {
        this.concurrency = concurrency;
        return self();
    }

    @Override
    public JniWrapperConfigBuilder jniWrapperConfig() {
        return jniWrapperConfig;
    }

    public T jniWrapperConfig(final JniWrapperConfig jniWrapperConfig) {
        this.jniWrapperConfig = new JniWrapperConfigBuilder(jniWrapperConfig);
        return self();
    }

    @Override
    public DataType dataType() {
        return dataType;
    }

    public T dataType(final DataType dataType) {
        this.dataType = dataType;
        return self();
    }

    @Override
    public DataExtractorConfigBuilder dataExtractorConfig() {
        return dataExtractorConfig;
    }

    public T dataExtractorConfig(
        final DataExtractorConfig dataExtractorConfig)
    {
        this.dataExtractorConfig =
            new DataExtractorConfigBuilder(dataExtractorConfig);
        return self();
    }

    @Override
    public ContentType contentType() {
        return contentType;
    }

    public T contentType(final ContentType contentType) {
        this.contentType = contentType;
        return self();
    }
}

