package ru.yandex.cokemulator.srw;

import org.apache.http.entity.ContentType;

import ru.yandex.client.cocaine.worker.http.unistorage.UnistorageHttpServiceConfigDefaults;
import ru.yandex.cokemulator.DataType;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfigDefaults;
import ru.yandex.util.storage.DataExtractorConfig;
import ru.yandex.util.storage.DataExtractorConfigDefaults;

public class CokemulatorSrwConfigDefaults
    extends UnistorageHttpServiceConfigDefaults
    implements CokemulatorSrwConfig
{
    public static final CokemulatorSrwConfigDefaults INSTANCE =
        new CokemulatorSrwConfigDefaults();

    protected CokemulatorSrwConfigDefaults() {
    }

    @Override
    public int concurrency() {
        return Integer.MAX_VALUE;
    }

    @Override
    public JniWrapperConfig jniWrapperConfig() {
        return JniWrapperConfigDefaults.INSTANCE;
    }

    @Override
    public DataType dataType() {
        return DataType.RAW;
    }

    @Override
    public DataExtractorConfig dataExtractorConfig() {
        return DataExtractorConfigDefaults.INSTANCE;
    }

    @Override
    public ContentType contentType() {
        return ContentType.APPLICATION_JSON;
    }
}

