package ru.yandex.cokemulator.srw;

import org.apache.http.entity.ContentType;

import ru.yandex.client.cocaine.worker.http.unistorage.ImmutableUnistorageHttpServiceConfig;
import ru.yandex.cokemulator.DataType;
import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.util.storage.ImmutableDataExtractorConfig;

public class ImmutableCokemulatorSrwConfig
    extends ImmutableUnistorageHttpServiceConfig
    implements CokemulatorSrwConfig
{
    private final int concurrency;
    private final ImmutableJniWrapperConfig jniWrapperConfig;
    private final DataType dataType;
    private final ImmutableDataExtractorConfig dataExtractorConfig;
    private final ContentType contentType;

    public ImmutableCokemulatorSrwConfig(final CokemulatorSrwConfig config)
        throws ConfigException
    {
        super(config);
        concurrency = CONCURRENCY.validate(config.concurrency());
        jniWrapperConfig =
            new ImmutableJniWrapperConfig(config.jniWrapperConfig());
        dataType = config.dataType();
        dataExtractorConfig =
            new ImmutableDataExtractorConfig(config.dataExtractorConfig());
        contentType = config.contentType();

        if (contentType == null) {
            throw new ConfigException("Content type is not set");
        }
    }

    @Override
    public int concurrency() {
        return concurrency;
    }

    @Override
    public ImmutableJniWrapperConfig jniWrapperConfig() {
        return jniWrapperConfig;
    }

    @Override
    public DataType dataType() {
        return dataType;
    }

    @Override
    public ImmutableDataExtractorConfig dataExtractorConfig() {
        return dataExtractorConfig;
    }

    @Override
    public ContentType contentType() {
        return contentType;
    }
}

