package ru.yandex.client.cocaine;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractCocaineServiceConfigBuilder
    <T extends AbstractCocaineServiceConfigBuilder<T>>
    implements CocaineServiceConfig
{
    private int connectTimeout;
    private long readTimeout;
    private int queueSize;

    protected AbstractCocaineServiceConfigBuilder(
        final CocaineServiceConfig config)
    {
        connectTimeout(config.connectTimeout());
        readTimeout(config.readTimeout());
        queueSize(config.queueSize());
    }

    protected AbstractCocaineServiceConfigBuilder(
        final IniConfig config,
        final CocaineServiceConfig defaults)
        throws ConfigException
    {
        connectTimeout(
            CONNECT_TIMEOUT.extract(config, defaults.connectTimeout()));
        readTimeout(READ_TIMEOUT.extract(config, defaults.readTimeout()));
        queueSize(QUEUE_SIZE.extract(config, defaults.queueSize()));
    }

    protected abstract T self();

    @Override
    public int connectTimeout() {
        return connectTimeout;
    }

    public T connectTimeout(final int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return self();
    }

    @Override
    public long readTimeout() {
        return readTimeout;
    }

    public T readTimeout(final long readTimeout) {
        this.readTimeout = readTimeout;
        return self();
    }

    @Override
    public int queueSize() {
        return queueSize;
    }

    public T queueSize(final int queueSize) {
        this.queueSize = queueSize;
        return self();
    }
}

