package ru.yandex.client.cocaine;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

import cocaine.service.invocation.InvocationRequest;

public class AsyncCocaineClient extends AbstractCocaineClient {
    private static final InvocationRequest STOP_REQUEST =
        new InvocationRequest(0, 0L, null, null);

    private final OutputStream out;
    private final Thread writeThread;
    private final BlockingQueue<InvocationRequest> queue;

    public AsyncCocaineClient(
        final CocaineClientContext clientContext,
        final AsyncCocaineClientContext asyncClientContext)
    {
        super(clientContext);
        out = new BufferedOutputStream(clientContext.socket().out());
        writeThread =
            asyncClientContext.writeThreadFactory().newThread(
                () -> writeLoop());
        int queueSize = asyncClientContext.queueSize();
        if (queueSize < 0) {
            queue = new LinkedBlockingQueue<>();
        } else {
            queue = new ArrayBlockingQueue<>(queueSize);
        }
    }

    @Override
    public void start() {
        super.start();
        writeThread.start();
    }

    @Override
    public void close() throws IOException {
        try {
            queue.put(STOP_REQUEST);
            super.close();
            writeThread.join();
        } catch (InterruptedException e) {
            // Keep calm and leave
        }
    }

    @Override
    public void sendRequest(final InvocationRequest request) {
        try {
            queue.put(request);
        } catch (InterruptedException e) {
            // Keep calm and leave
        }
    }

    private void writeLoop() {
        while (true) {
            try {
                InvocationRequest request = queue.take();
                while (true) {
                    if (request == STOP_REQUEST) {
                        out.flush();
                        return;
                    }
                    serializeRequest(request, out);
                    request = queue.poll();
                    if (request == null) {
                        break;
                    }
                }
                out.flush();
            } catch (IOException e) {
                if (!closed) {
                    callback.writeFailed(e);
                }
                break;
            } catch (InterruptedException e) {
                break;
            }
        }
    }
}

