package ru.yandex.client.cocaine;

import java.util.concurrent.ThreadFactory;

public class AsyncCocaineClientFactory implements CocaineClientFactory {
    private final ThreadFactory eventThreadFactory;
    private final AsyncCocaineClientContext asyncClientContext;

    public AsyncCocaineClientFactory(
        final ThreadFactory eventThreadFactory,
        final AsyncCocaineClientContext asyncClientContext)
    {
        this.eventThreadFactory = eventThreadFactory;
        this.asyncClientContext = asyncClientContext;
    }

    @Override
    public AsyncCocaineClient create(
        final UniSocket socket,
        final CocaineClientCallback callback)
    {
        return new AsyncCocaineClient(
            new CocaineClientContext(socket, callback, eventThreadFactory),
            asyncClientContext);
    }
}

