package ru.yandex.client.cocaine;

import ru.yandex.concurrent.SingleNamedThreadFactory;
import ru.yandex.concurrent.ThreadFactoryConfig;

public class CocaineClientFactoryFactory {
    private final ThreadFactoryConfig threadFactoryConfig;

    public CocaineClientFactoryFactory(
        final ThreadFactoryConfig threadFactoryConfig)
    {
        this.threadFactoryConfig = threadFactoryConfig;
    }

    public CocaineClientFactory create(final int queueSize) {
        if (queueSize == 0) {
            return new SyncCocaineClientFactory(
                new SingleNamedThreadFactory(threadFactoryConfig));
        } else {
            return new AsyncCocaineClientFactory(
                new SingleNamedThreadFactory(
                    new ThreadFactoryConfig(
                        threadFactoryConfig.name() + "-EventThread",
                        threadFactoryConfig)),
                new AsyncCocaineClientContext(
                    queueSize,
                    new SingleNamedThreadFactory(
                        new ThreadFactoryConfig(
                            threadFactoryConfig.name() + "-WriteThread",
                            threadFactoryConfig))));
        }
    }
}

