package ru.yandex.client.cocaine;

import org.msgpack.type.Value;

public class CocaineProtocolException extends CocaineException {
    private static final long serialVersionUID = 0L;

    public CocaineProtocolException() {
    }

    public CocaineProtocolException(final String message) {
        super(message);
    }

    public CocaineProtocolException(final Throwable cause) {
        super(cause);
    }

    public CocaineProtocolException(final Value payload) {
        this(
            "Unexpected payload format: " + payload.getType()
            + '(' + payload + ')');
    }

    public CocaineProtocolException(
        final String messageType,
        final Value payload)
    {
        this("Unexpected message type: " + messageType + '(' + payload + ')');
    }

    public CocaineProtocolException(
        final String message,
        final Throwable cause)
    {
        super(message, cause);
    }
}

