package ru.yandex.client.cocaine;

import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.DoubleToIntegerValidator;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.PositiveValidator;

public interface CocaineServiceConfig {
    ParameterConfig<Integer> CONNECT_TIMEOUT = new ParameterConfig<>(
        "connect-timeout",
        DurationParser.INSTANCE.andThen(DoubleToIntegerValidator.INSTANCE),
        PositiveValidator.instance());
    ParameterConfig<Long> READ_TIMEOUT = new ParameterConfig<>(
        "read-timeout",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        PositiveValidator.instance());
    ParameterConfig<Integer> QUEUE_SIZE =
        new ParameterConfig<>("queue-size", Integer::valueOf, x -> x);

    int connectTimeout();

    long readTimeout();

    int queueSize();
}

