package ru.yandex.client.cocaine;

import java.util.Map;

import ru.yandex.client.cocaine.protocol.CocaineMethodApi;

public class CocaineServiceContext {
    private final UniSocket socket;
    private final Map<Integer, CocaineMethodApi> methods;
    private final CocaineClientFactory clientFactory;

    public CocaineServiceContext(
        final UniSocket socket,
        final Map<Integer, CocaineMethodApi> methods,
        final CocaineClientFactory clientFactory)
    {
        this.socket = socket;
        this.methods = methods;
        this.clientFactory = clientFactory;
    }

    public UniSocket socket() {
        return socket;
    }

    public Map<Integer, CocaineMethodApi> methods() {
        return methods;
    }

    public CocaineClientFactory clientFactory() {
        return clientFactory;
    }
}

