package ru.yandex.client.cocaine;

public class CocaineServiceException extends CocaineException {
    private static final long serialVersionUID = 0L;

    public static final class Category {
        public static final int FRAMEWORK = 42;
        public static final int UNISTORAGE = 0x5b09;

        private Category() {
        }
    }

    public static final class Code {
        public static final int NO_HANDLER = 200;
        public static final int INVOCATION_FAILED = 212;
        public static final int SERVICE_DISCONNECTED = 220;

        private Code() {
        }
    }

    public static final class UnistorageCode {
        public static final int INVALID_INPUT_DATA = 4;
        public static final int FILE_NOT_FOUND = 6;
        public static final int GENERIC_AUTH_ERROR = 200;
        public static final int GENERIC_ACL_ERROR = 300;

        private UnistorageCode() {
        }
    }

    private final int category;
    private final int code;
    private final String message;

    public CocaineServiceException(
        final int category,
        final int code,
        final String message)
    {
        this.category = category;
        this.code = code;
        this.message = message;
    }

    public int category() {
        return category;
    }

    public int code() {
        return code;
    }

    @Override
    public String getMessage() {
        return "Error: " + message
            + " (category: " + category
            + ", code: " + code + ')';
    }
}

