package ru.yandex.client.cocaine;

import java.io.IOException;
import java.net.Socket;

import ru.yandex.client.cocaine.protocol.CocaineServiceInfo;

public class CocaineServiceFactory {
    private final int connectTimeout;
    private final IOErrorHandler ioErrorHandler;
    private final CocaineClientFactory clientFactory;

    public CocaineServiceFactory(
        final int connectTimeout,
        final IOErrorHandler ioErrorHandler,
        final CocaineClientFactory clientFactory)
    {
        this.connectTimeout = connectTimeout;
        this.ioErrorHandler = ioErrorHandler;
        this.clientFactory = clientFactory;
    }

    public CocaineService createService(final CocaineServiceInfo serviceInfo)
        throws IOException
    {
        Socket socket = new Socket();
        socket.connect(serviceInfo.endpoints().get(0), connectTimeout);
        socket.setSoTimeout(connectTimeout);
        return new CocaineService(
            ioErrorHandler,
            new CocaineServiceContext(
                new UniSocket(
                    socket,
                    socket.getInputStream(),
                    socket.getOutputStream()),
                serviceInfo.methods(),
                clientFactory));
    }
}

