package ru.yandex.client.cocaine;

import ru.yandex.parser.config.ConfigException;

public class ImmutableCocaineServiceConfig implements CocaineServiceConfig {
    private final int connectTimeout;
    private final long readTimeout;
    private final int queueSize;

    public ImmutableCocaineServiceConfig(final CocaineServiceConfig config)
        throws ConfigException
    {
        connectTimeout = CONNECT_TIMEOUT.validate(config.connectTimeout());
        readTimeout = READ_TIMEOUT.validate(config.readTimeout());
        queueSize = QUEUE_SIZE.validate(config.queueSize());
    }

    @Override
    public int connectTimeout() {
        return connectTimeout;
    }

    @Override
    public long readTimeout() {
        return readTimeout;
    }

    @Override
    public int queueSize() {
        return queueSize;
    }
}

