package ru.yandex.client.cocaine;

import org.msgpack.type.Value;

public enum IntegerCocainePayloadDeserializer
    implements CocainePayloadDeserializer<Integer>
{
    INSTANCE;

    @Override
    public Integer deserialize(final String messageType, final Value payload)
        throws CocaineException
    {
        if (payload.isIntegerValue()) {
            return payload.asIntegerValue().getInt();
        } else {
            throw new UnexpectedCocaineMessageException(messageType, payload);
        }
    }
}

