package ru.yandex.client.cocaine;

public class PipedCocaineSessionFactory<T>
    implements CocaineSessionFactory<PipedCocaineSession<T>>
{
    private final long readTimeout;
    private final CocainePayloadDeserializer<? extends T> deserializer;

    public PipedCocaineSessionFactory(
        final long readTimeout,
        final CocainePayloadDeserializer<? extends T> deserializer)
    {
        this.readTimeout = readTimeout;
        this.deserializer = deserializer;
    }

    @Override
    public PipedCocaineSession<T> createSession(
        final CocaineSessionContext cocaineSessionContext)
    {
        return new PipedCocaineSession<>(
            cocaineSessionContext,
            readTimeout,
            deserializer);
    }
}

