package ru.yandex.client.cocaine;

import java.io.IOException;

import cocaine.service.invocation.InvocationRequest;

import ru.yandex.function.OutputStreamProcessorAdapter;
import ru.yandex.io.DecodableByteArrayOutputStream;

public class SyncCocaineClient extends AbstractCocaineClient {
    private final OutputStreamProcessorAdapter out;

    public SyncCocaineClient(final CocaineClientContext clientContext) {
        super(clientContext);
        out = new OutputStreamProcessorAdapter(clientContext.socket().out());
    }

    @Override
    public void sendRequest(final InvocationRequest request) {
        // DecodableByteArrayOutputStream provides I/O buffering which is done
        // independently in each concurrent thread, so BufferedOutputStream is
        // not used here
        DecodableByteArrayOutputStream buf =
            new DecodableByteArrayOutputStream();
        try {
            serializeRequest(request, buf);
            synchronized (out) {
                buf.processWith(out);
            }
        } catch (IOException e) {
            if (!closed) {
                callback.writeFailed(e);
            }
        }
    }
}

