package ru.yandex.client.cocaine;

import cocaine.message.Message;
import org.msgpack.type.Value;

public class UnexpectedCocaineMessageException
    extends CocaineProtocolException
{
    private static final long serialVersionUID = 0L;

    public UnexpectedCocaineMessageException(final Message message) {
        this(
            "Unexpected message: [session=" + message.getSession()
            + ",type=" + message.getType()
            + ",headers=" + message.getHeaders()
            + ",payload=" + message.getPayload() + ']');
    }

    public UnexpectedCocaineMessageException(
        final String messageType,
        final Value payload)
    {
        this(
            "Unexpected message received with type '" + messageType
            + "' and payload: " + payload);
    }

    public UnexpectedCocaineMessageException(final String message) {
        super(message);
    }
}

