package ru.yandex.client.cocaine;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import ru.yandex.function.GenericAutoCloseable;

public class UniSocket implements GenericAutoCloseable<IOException> {
    private final Closeable closeable;
    private final InputStream in;
    private final OutputStream out;

    public UniSocket(
        final Closeable closeable,
        final InputStream in,
        final OutputStream out)
    {
        this.closeable = closeable;
        this.in = in;
        this.out = out;
    }

    public InputStream in() {
        return in;
    }

    public OutputStream out() {
        return out;
    }

    @Override
    public void close() throws IOException {
        closeable.close();
    }

    @Override
    public String toString() {
        return closeable.toString();
    }
}

