package ru.yandex.client.cocaine.protocol;

import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

import ru.yandex.client.cocaine.CocaineProtocolException;

public class CocaineServiceInfo {
    private final List<SocketAddress> endpoints;
    private final Map<String, Integer> methodNameToId;
    private final Map<Integer, CocaineMethodApi> methods;

    public CocaineServiceInfo(
        final List<SocketAddress> endpoints,
        final Map<String, Integer> methodNameToId,
        final Map<Integer, CocaineMethodApi> methods)
    {
        this.endpoints = endpoints;
        this.methodNameToId = methodNameToId;
        this.methods = methods;
    }

    public List<SocketAddress> endpoints() {
        return endpoints;
    }

    public Integer methodId(final String methodName)
        throws CocaineProtocolException
    {
        Integer methodId = methodNameToId.get(methodName);
        if (methodId == null) {
            throw new CocaineProtocolException(
                '\'' + methodName + "' method not found");
        }
        return methodId;
    }

    public Map<Integer, CocaineMethodApi> methods() {
        return methods;
    }
}

