package ru.yandex.client.cocaine.protocol;

import java.io.IOException;
import java.util.Collections;

import ru.yandex.client.cocaine.CocaineException;
import ru.yandex.client.cocaine.CocaineService;
import ru.yandex.client.cocaine.CocaineServiceFactory;
import ru.yandex.client.cocaine.CocaineSessionFactory;
import ru.yandex.client.cocaine.PipedCocaineSession;
import ru.yandex.client.cocaine.PipedCocaineSessionFactory;
import ru.yandex.client.cocaine.protocol.fsm.BasicFsmState;
import ru.yandex.client.cocaine.protocol.fsm.BasicFsmTransition;
import ru.yandex.client.cocaine.protocol.fsm.FsmState;
import ru.yandex.function.GenericAutoCloseable;

public class LocatorService implements GenericAutoCloseable<IOException> {
    private static final int RESOLVE_METHOD_ID = 0;
    private static final int VALUE_MESSAGE_ID = 0;
    private static final int ERROR_MESSAGE_ID = 1;

    private final CocaineService service;
    private final CocaineSessionFactory<
        PipedCocaineSession<CocaineServiceInfo>>
        sessionFactory;

    public LocatorService(
        final LocatorServiceConfig config,
        final CocaineProtocolRegistry cocaineProtocolRegistry,
        final CocaineServiceFactory cocaineServiceFactory)
        throws IOException
    {
        BasicFsmState receiveState = new BasicFsmState(2);
        receiveState.addTransition(
            new BasicFsmTransition(
                VALUE_MESSAGE_ID,
                DefaultCocaineProtocolRegistry.VALUE,
                FsmState.FINAL));
        receiveState.addTransition(
            new BasicFsmTransition(
                ERROR_MESSAGE_ID,
                DefaultCocaineProtocolRegistry.ERROR,
                FsmState.FINAL));
        service =
            cocaineServiceFactory.createService(
                new CocaineServiceInfo(
                    Collections.singletonList(config.endpoint()),
                    Collections.singletonMap("resolve", RESOLVE_METHOD_ID),
                    Collections.singletonMap(
                        RESOLVE_METHOD_ID,
                        new CocaineMethodApi(
                            cocaineProtocolRegistry.findProtocol(
                                DefaultCocaineProtocolRegistry.VALUE,
                                DefaultCocaineProtocolRegistry.ERROR),
                            FsmState.FINAL,
                            receiveState))));
        sessionFactory = new PipedCocaineSessionFactory<>(
            config.readTimeout(),
            new CocaineServiceInfoDeserializer(cocaineProtocolRegistry));
    }

    public void start() {
        service.start();
    }

    @Override
    public void close() throws IOException {
        service.close();
    }

    public CocaineServiceInfo resolve(final String serviceName)
        throws CocaineException, IOException, InterruptedException
    {
        try (PipedCocaineSession<CocaineServiceInfo> session =
                service.createSession(
                    sessionFactory,
                    RESOLVE_METHOD_ID,
                    Collections.singletonList(serviceName)))
        {
            return session.get();
        }
    }
}

