package ru.yandex.client.cocaine.protocol.fsm;

import java.util.HashMap;
import java.util.Map;

public class BasicFsmState implements FsmState {
    private final Map<Integer, FsmTransition> idToTransition;
    private final Map<String, FsmTransition> nameToTransition;

    public BasicFsmState(final int expectedLength) {
        idToTransition = new HashMap<>(expectedLength << 1);
        nameToTransition = new HashMap<>(expectedLength << 1);
    }

    @Override
    public boolean finalState() {
        return idToTransition.isEmpty();
    }

    public void addTransition(final FsmTransition transition) {
        idToTransition.put(transition.messageId(), transition);
        nameToTransition.put(transition.messageName(), transition);
    }

    @Override
    public FsmTransition transition(final int messageId) {
        return idToTransition.get(messageId);
    }

    @Override
    public FsmTransition transition(final String messageName) {
        return nameToTransition.get(messageName);
    }
}

