package ru.yandex.client.cocaine.unistorage;

import ru.yandex.client.cocaine.AbstractCocaineServiceConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractUnistorageServiceConfigBuilder
    <T extends AbstractUnistorageServiceConfigBuilder<T>>
    extends AbstractCocaineServiceConfigBuilder<T>
    implements UnistorageServiceConfig
{
    private boolean prefetch;

    protected AbstractUnistorageServiceConfigBuilder(
        final UnistorageServiceConfig config)
    {
        super(config);
        prefetch(config.prefetch());
    }

    protected AbstractUnistorageServiceConfigBuilder(
        final IniConfig config,
        final UnistorageServiceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        prefetch(PREFETCH.extract(config, defaults.prefetch()));
    }

    @Override
    public boolean prefetch() {
        return prefetch;
    }

    public T prefetch(final boolean prefetch) {
        this.prefetch = prefetch;
        return self();
    }
}

