package ru.yandex.client.cocaine.unistorage;

import ru.yandex.client.cocaine.ImmutableCocaineServiceConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableUnistorageServiceConfig
    extends ImmutableCocaineServiceConfig
    implements UnistorageServiceConfig
{
    private final boolean prefetch;

    public ImmutableUnistorageServiceConfig(
        final UnistorageServiceConfig config)
        throws ConfigException
    {
        super(config);
        prefetch = PREFETCH.validate(config.prefetch());
    }

    @Override
    public boolean prefetch() {
        return prefetch;
    }
}

