package ru.yandex.client.cocaine.unistorage;

import java.util.Objects;

import org.msgpack.type.MapValue;
import org.msgpack.type.Value;
import org.msgpack.type.ValueFactory;

import ru.yandex.client.cocaine.UnexpectedCocaineMessageException;

public class UnistorageMetaResponse implements UnistorageResponse {
    private static final Value ATTRIBUTES =
        ValueFactory.createRawValue("attributes");
    private static final Value KEY =
        ValueFactory.createRawValue("key");
    private static final Value SIZE =
        ValueFactory.createRawValue("size");
    private static final Value TIMESTAMP_MS =
        ValueFactory.createRawValue("timestamp_ms");

    private final String attributes;
    private final String key;
    private final long size;
    private final Long timestamp;

    public UnistorageMetaResponse(final MapValue payload)
        throws UnexpectedCocaineMessageException
    {
        attributes = Objects.toString(payload.get(ATTRIBUTES), null);
        key = Objects.toString(payload.get(KEY), null);
        size = getLong(payload, SIZE);
        if (payload.containsKey(TIMESTAMP_MS)) {
            timestamp = getLong(payload, TIMESTAMP_MS);
        } else {
            timestamp = null;
        }
    }

    private static long getLong(final MapValue map, final Value key)
        throws UnexpectedCocaineMessageException
    {
        Value value = map.get(key);
        if (value == null || !value.isIntegerValue()) {
            throw new UnexpectedCocaineMessageException(
                "Bad value for key " + key + " in payload " + map);
        } else {
            return value.asIntegerValue().getLong();
        }
    }

    public String attributes() {
        return attributes;
    }

    public String key() {
        return key;
    }

    public long size() {
        return size;
    }

    public Long timestamp() {
        return timestamp;
    }

    @Override
    public UnistorageMetaResponse asMeta() {
        return this;
    }
}

