package ru.yandex.client.cocaine.unistorage;

import ru.yandex.client.cocaine.CocaineProtocolException;
import ru.yandex.client.cocaine.protocol.fsm.FsmState;
import ru.yandex.client.cocaine.protocol.fsm.FsmTransition;

public class UnistorageReadMethodApi {
    private final int metaMessageId;
    private final int nextMessageId;
    private final int closeMessageId;

    public UnistorageReadMethodApi(final FsmState transmitState)
        throws CocaineProtocolException
    {
        metaMessageId = messageId(transmitState, "meta");
        nextMessageId = messageId(transmitState, "next");
        closeMessageId = messageId(transmitState, "close");
    }

    private static int messageId(
        final FsmState state,
        final String messageName)
        throws CocaineProtocolException
    {
        FsmTransition transition = state.transition(messageName);
        if (transition == null) {
            throw new CocaineProtocolException(
                '\'' + messageName + "' request not found");
        } else {
            return transition.messageId();
        }
    }

    public int metaMessageId() {
        return metaMessageId;
    }

    public int nextMessageId() {
        return nextMessageId;
    }

    public int closeMessageId() {
        return closeMessageId;
    }
}

