package ru.yandex.client.cocaine.unistorage;

import org.msgpack.type.Value;

import ru.yandex.client.cocaine.CocaineException;
import ru.yandex.client.cocaine.CocainePayloadDeserializer;
import ru.yandex.client.cocaine.UnexpectedCocaineMessageException;
import ru.yandex.client.cocaine.protocol.DefaultCocaineProtocolRegistry;

public enum UnistorageResponseDeserializer
    implements CocainePayloadDeserializer<UnistorageResponse>
{
    INSTANCE;

    @Override
    public UnistorageResponse deserialize(
        final String messageType,
        final Value payload)
        throws CocaineException
    {
        if (payload.isRawValue()
            && DefaultCocaineProtocolRegistry.CHUNK.equals(messageType))
        {
            return new UnistorageDataResponse(payload.asRawValue());
        } else if (payload.isMapValue()
            && DefaultCocaineProtocolRegistry.META.equals(messageType))
        {
            return new UnistorageMetaResponse(payload.asMapValue());
        } else {
            // service error message already handled by CocaineProtocol
            throw new UnexpectedCocaineMessageException(messageType, payload);
        }
    }
}

