package ru.yandex.client.cocaine.unistorage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import cocaine.hpack.HeaderField;

import ru.yandex.client.cocaine.CocaineException;
import ru.yandex.client.cocaine.CocaineProtocolException;
import ru.yandex.client.cocaine.CocaineService;
import ru.yandex.client.cocaine.CocaineServiceFactory;
import ru.yandex.client.cocaine.CocaineSessionFactory;
import ru.yandex.client.cocaine.PipedCocaineSession;
import ru.yandex.client.cocaine.PipedCocaineSessionFactory;
import ru.yandex.client.cocaine.protocol.CocaineServiceInfo;
import ru.yandex.function.GenericAutoCloseable;

public class UnistorageService implements GenericAutoCloseable<IOException> {
    private final int readMethodId;
    private final UnistorageReadMethodApi readMethodApi;
    private final CocaineService service;
    private final CocaineSessionFactory<
        PipedCocaineSession<UnistorageResponse>>
        sessionFactory;
    private final boolean prefetch;

    public UnistorageService(
        final CocaineServiceInfo serviceInfo,
        final CocaineServiceFactory cocaineServiceFactory,
        final ImmutableUnistorageServiceConfig config)
        throws IOException, CocaineProtocolException
    {
        // TODO: use only boxed values or use primitive to object map
        readMethodId = serviceInfo.methodId("read2");
        readMethodApi = new UnistorageReadMethodApi(
            serviceInfo.methods().get(readMethodId).initialTransmitState());
        service = cocaineServiceFactory.createService(serviceInfo);
        sessionFactory = new PipedCocaineSessionFactory<>(
            config.readTimeout(),
            UnistorageResponseDeserializer.INSTANCE);
        prefetch = config.prefetch();
    }

    public void start() {
        service.start();
    }

    @Override
    public void close() throws IOException {
        service.close();
    }

    private UnistorageSession read(
        final List<Object> args,
        final List<HeaderField> headers)
        throws CocaineException, IOException
    {
        return new UnistorageSession(
            service.createSession(sessionFactory, readMethodId, args, headers),
            readMethodApi,
            prefetch);
    }

    public UnistorageSession read(
        final String key,
        final List<HeaderField> headers)
        throws CocaineException, IOException
    {
        return read(Collections.singletonList(key), headers);
    }

    // CSOFF: ParameterNumber
    public UnistorageSession read(
        final String key,
        final long offset,
        final long size,
        final List<HeaderField> headers)
        throws CocaineException, IOException
    {
        return read(Arrays.asList(key, offset, size), headers);
    }

    public UnistorageSession read(
        final String key,
        final long offset,
        final long size,
        final long chunkSize,
        final List<HeaderField> headers)
        throws CocaineException, IOException
    {
        return read(Arrays.asList(key, offset, size, chunkSize), headers);
    }

    public UnistorageSession read(
        final String key,
        final long offset,
        final long size,
        final long chunkSize,
        final Map<String, Object> params,
        final List<HeaderField> headers)
        throws CocaineException, IOException
    {
        return read(
            Arrays.asList(key, offset, size, chunkSize, params),
            headers);
    }
    // CSON: ParameterNumber

    @Override
    public String toString() {
        return "Unistorage(" + service + ')';
    }
}

