package ru.yandex.client.cocaine.unistorage;

import java.io.IOException;
import java.util.Collections;

import ru.yandex.client.cocaine.CocaineException;
import ru.yandex.client.cocaine.PipedCocaineSession;
import ru.yandex.function.GenericAutoCloseable;

public class UnistorageSession implements GenericAutoCloseable<IOException> {
    private final PipedCocaineSession<UnistorageResponse> session;
    private final UnistorageReadMethodApi readMethodApi;
    private final boolean prefetch;
    private boolean opened = true;

    public UnistorageSession(
        final PipedCocaineSession<UnistorageResponse> session,
        final UnistorageReadMethodApi readMethodApi,
        final boolean prefetch)
    {
        this.session = session;
        this.readMethodApi = readMethodApi;
        this.prefetch = prefetch;
    }

    public boolean prefetch() {
        return prefetch;
    }

    @Override
    public void close() throws IOException {
        if (opened) {
            opened = false;
            try (PipedCocaineSession<UnistorageResponse> session =
                    this.session)
            {
                session.sendMessage(
                    readMethodApi.closeMessageId(),
                    Collections.emptyList());
            }
        }
    }

    public void requestMeta() throws IOException {
        session.sendMessage(
            readMethodApi.metaMessageId(),
            Collections.emptyList());
    }

    public void requestChunk() throws IOException {
        session.sendMessage(
            readMethodApi.nextMessageId(),
            Collections.emptyList());
    }

    public UnistorageResponse get()
        throws CocaineException, IOException, InterruptedException
    {
        return session.get();
    }

    @Override
    public String toString() {
        return "UnistorageSession(" + session + ')';
    }
}

