package ru.yandex.client.cocaine.worker.http;

import ru.yandex.client.cocaine.worker.AbstractCocaineWorkerServiceConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractCocaineHttpServiceConfigBuilder
    <T extends AbstractCocaineHttpServiceConfigBuilder<T>>
    extends AbstractCocaineWorkerServiceConfigBuilder<T>
    implements CocaineHttpServiceConfig
{
    private int workers;
    private int requestsQueueSize;
    private long minRequestTime;
    private long gracefulShutdownTimeout;

    protected AbstractCocaineHttpServiceConfigBuilder(
        final CocaineHttpServiceConfig config)
    {
        super(config);
        workers(config.workers());
        requestsQueueSize(config.requestsQueueSize());
        minRequestTime(config.minRequestTime());
        gracefulShutdownTimeout(config.gracefulShutdownTimeout());
    }

    protected AbstractCocaineHttpServiceConfigBuilder(
        final IniConfig config,
        final CocaineHttpServiceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        workers(WORKERS.extract(config, defaults.workers()));
        requestsQueueSize(
            REQUESTS_QUEUE_SIZE.extract(config, defaults.requestsQueueSize()));
        minRequestTime(
            MIN_REQUEST_TIME.extract(config, defaults.minRequestTime()));
        gracefulShutdownTimeout(
            GRACEFUL_SHUTDOWN_TIMEOUT.extract(
                config,
                defaults.gracefulShutdownTimeout()));
    }

    @Override
    public int workers() {
        return workers;
    }

    public T workers(final int workers) {
        this.workers = workers;
        return self();
    }

    @Override
    public int requestsQueueSize() {
        return requestsQueueSize;
    }

    public T requestsQueueSize(final int requestsQueueSize) {
        this.requestsQueueSize = requestsQueueSize;
        return self();
    }

    @Override
    public long minRequestTime() {
        return minRequestTime;
    }

    public T minRequestTime(final long minRequestTime) {
        this.minRequestTime = minRequestTime;
        return self();
    }

    @Override
    public long gracefulShutdownTimeout() {
        return gracefulShutdownTimeout;
    }

    public T gracefulShutdownTimeout(final long gracefulShutdownTimeout) {
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        return self();
    }
}

