package ru.yandex.client.cocaine.worker.http;

import java.io.BufferedOutputStream;
import java.io.IOException;

// Calls CocaineHttpOutputStream.sendEof() instead of simpl .close()
// Not expected to be used in try-with-resources statements, as .sendEof()
// should be called only on successful completion
public class BufferedCocaineHttpOutputStreamCloser
    extends BufferedOutputStream
{
    private final CocaineHttpOutputStream cocaineOut;

    public BufferedCocaineHttpOutputStreamCloser(
        final CocaineHttpOutputStream cocaineOut)
    {
        super(cocaineOut);
        this.cocaineOut = cocaineOut;
    }

    @Override
    public void close() throws IOException {
        flush();
        cocaineOut.sendEof();
    }
}

