package ru.yandex.client.cocaine.worker.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import cocaine.hpack.HeaderField;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;

import ru.yandex.client.cocaine.CocaineServiceException;
import ru.yandex.client.cocaine.worker.CocaineWorkerSession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.io.StringBuilderWriter;

public class CocaineDummyHttpRequestHandler
    implements CocaineHttpRequestHandler
{
    private static final Header CONTENT_LENGTH_0 =
        new BasicHeader(HttpHeaders.CONTENT_LENGTH, "0");

    private final int statusCode;
    private final HttpEntity entity;
    private final List<Header> headers;

    public CocaineDummyHttpRequestHandler(
        final int statusCode,
        final String body)
    {
        this(
            statusCode,
            new StringEntity(body, CharsetUtils.DEFAULT_CONTENT_TYPE));
    }

    public CocaineDummyHttpRequestHandler(
        final int statusCode,
        final HttpEntity entity)
    {
        this(statusCode, entity, Collections.emptyList());
    }

    public CocaineDummyHttpRequestHandler(
        final int statusCode,
        final HttpEntity entity,
        final Header... headers)
    {
        this(statusCode, entity, Arrays.asList(headers));
    }

    public CocaineDummyHttpRequestHandler(
        final int statusCode,
        final HttpEntity entity,
        final List<Header> headers)
    {
        this.statusCode = statusCode;
        this.entity = entity;
        this.headers = headers;
    }

    private void addHeader(final List<Header> headers, final Header header) {
        if (header != null) {
            headers.add(header);
        }
    }

    @Override
    public void handle(
        final HttpRequest request,
        final List<HeaderField> cocaineHeaders,
        final CocaineWorkerSession session)
    {
        try (CocaineWorkerSession workerSession = session) {
            // Content-Type, Content-Length & Content-Encoding
            List<Header> headers =
                new ArrayList<>(this.headers.size() + 1 + 1 + 1);
            if (entity == null) {
                if (statusCode != HttpStatus.SC_NO_CONTENT
                    && statusCode != HttpStatus.SC_NOT_MODIFIED
                    && statusCode != HttpStatus.SC_RESET_CONTENT)
                {
                    headers.add(CONTENT_LENGTH_0);
                }
            } else {
                long contentLength = entity.getContentLength();
                if (contentLength >= 0L) {
                    headers.add(
                        new BasicHeader(
                            HttpHeaders.CONTENT_LENGTH,
                            Long.toString(contentLength)));
                }
                addHeader(headers, entity.getContentType());
                addHeader(headers, entity.getContentEncoding());
            }
            headers.addAll(this.headers);
            try (CocaineHttpOutputStream out = new CocaineHttpOutputStream(
                    workerSession,
                    statusCode,
                    headers))
            {
                if (entity != null) {
                    try {
                        entity.writeTo(out);
                    } catch (IOException e) {
                        StringBuilderWriter sbw = new StringBuilderWriter();
                        sbw.write(
                            "Failed to serialize entity: " + entity
                            + " with status code " + statusCode
                            + " on request " + request + ':' + ' ');
                        e.printStackTrace(sbw);
                        out.sendError(
                            CocaineServiceException.Category.FRAMEWORK,
                            CocaineServiceException.Code.INVOCATION_FAILED,
                            sbw.toString());
                    }
                }
                // will do nothing if error was already sent
                out.sendEof();
            } catch (IOException e) {
                // Nothing we can do here, session close will be done by
                // try-with-resources block
            }
        }
    }
}

